;USER AREA FOR BSTAM FOR TELEVIDEO TS-802 COMPUTER.
;WRITTEN BY KEITH PETERSEN, W8SDZ - 5/9/82
;
;BASED ON GENERALIZED INFORMATION SUPPLIED BY BYROM SOFTWARE.
;
;THIS VERSION WORKS WITH THE PRINTER PORT
;
PSTAT	EQU	23H	;PRINTER STATUS PORT
PDATA	EQU	21H	;PRINTER DATA PORT
;
;	IF YOU WISH TO USE OTHER REGISTERS SUCH AS HL,BC,DE
;	(NOT INCLUDING  SP  REGISTER)
;	BE SURE TO PUSH BSTAM'S REGISTERS ON TO STACK AND POP
;	THEM BACK OFF BEFORE RETURNING TO BSTAM.
;	THERE IS AMPLE ROOM TO PUSH ALL REGISTERS ONTO BSTAM'S
;	STACK, PLUS ROOM FOR 10 LEVELS OF CALL'S.
;
;	THERE ARE 300 BYTES OF USER SPACE AVAILABLE TO YOU.
;
;	THE JUMP'S CODED AT THE BEGINNING OF THIS PROGRAM
;	CANNOT BE MOVED IN ANY WAY.
;
BEGIN	ORG	103H
INITIL	JMP	INITIU			;UART/USART INITIALATION ENTRY POINT
INSPORT	JMP	INSPRU			;STATUS PORT READ ENTRY POINT
ERRSET	JMP	ERRSTU			;UART/USART ERROR RESET ENTRY POINT
INPORT	JMP	INPRTU			;READ DATA PORT ENTRY POINT
OUTPORT	JMP	OUTPRTU			;WRITE DATA PORT ENTRY POINT
;
;
INITIU	EQU	$
;	THIS IS THE UART/USART INITIALATION ROUTINE.
;	TO BE COMPATIBLE WITH MOST BSTAM USERS USE FOLLOWING
;	INITIALATION GUIDE LINES:
;		1. USE 1 STOP BIT	(OPTIONAL - 2)
;		2. USE 8 DATA BITS	(MUST)
;		3. USE 1 START BIT	(MUST)
;		4. USE 16X FOR CLOCK RATE 	(MUST)
;		5. USE ASYNCHRONOUS MODE ONLY	(MUST)
;
;
	CALL	SIGNON	;TELL USER WHAT'S IMPLEMENTED
	IN	PDATA	;CLEAR INPUT OF CHARS.
	IN	PDATA	;AGAIN TO MAKE SURE
	RET		;RETURN TO BSTAM
;
INSPRU	EQU	$
;	THIS IS THE STATUS READ PORT ROUTINE.
;	WHEN EXITING THIS ROUTINE BSTAM EXPECTS IN REGISTER A
;	THE FOLLOWING BITS TO BE SET IF NEEDED:
;		1. 20 BIT SET IF FRAMING ERROR
;		2. 10 BIT SET IF OVERRUN ERROR
;		3. 08 BIT SET IF PARITY  ERROR
;		4. 04 BIT SET IF TRANSMITTER EMPTY
;			IF YOUR UART/USART DOES NOT HAVE TRANSMITTER
;			EMPTY FEATURE, THEN ALLWAYS SET THIS BIT ON.
;		5. 02 BIT SET IF RECEIVER READY
;		6. 01 BIT SET IF TRANSMITTER READY
;		7. DO NOT SET THE 80 BIT OR 40 BIT
;
;    OURSTAT	TBE=04H
;		RDA=01H
;
	PUSH	B
	IN	PSTAT	;GET INFO BITS FROM STATUS PORT
	ANI	01H	;ISOLATE RDA BIT
	RLC		;SHIFT TO 02 BIT
	MOV	B,A	;SAVE
	IN	PSTAT	;GET STATUS AGAIN
	ANI	04H	;ISOLATE TBE BIT
	ORA	B	;COMBINE WITH RDA BIT
	ORI	01H	;ADD BOGUS TBE BIT FOR BSTAM
	POP	B
	RET
;
ERRSTU	EQU	$
;	THIS IS THE ERROR RESET FOR UART/USART ROUTINE.
;	YOUR UART/USART MAY NOT NEED TO BE RESET IF FRAMING,
;	OVERRUN, OR PARITY ERROR IS FOUND. IF THIS IS YOUR
;	CASE, JUST DO A RETURN.
;
	RET		;RETURN TO BSTAM
;
INPRTU	EQU	$
;	THIS IS THE READ DATA PORT ROUTINE.
;	BEFORE THIS ROUTINE IS ENTERED THE 02 BIT OF
;	STATUS READ ROUTINE MUST HAVE BEEN SET.
;	DO NOT CLEAR THE 80 BIT FROM THE DATA INPUT PORT.
;	RETURN WITH REGISTER A LOADED WITH INPUT DATA.
;
	IN	PDATA	;GET DATA FROM PORT
	RET		;RETURN TO BSTAM
;
OUTPRTU	EQU	$
;	THIS IS THE WRITE DATA PORT ROUTINE.
;	BEFORE THIS ROUTINE IS ENTERED THE 04 BIT AND 01 BIT
;	OF STATUS READ MUST BE SET.
;	DO NOT CLEAR THE 80 BIT FROM THE DATA OUPDATAUT PORT.
;	REGISTER A CONTAINS THE OUPDATAUT DATA.
;
	OUT	PDATA	;SEND DATA TO REMOTE CPU
	RET		;RETURN TO BSTAM
;
MESSGE:	DB	0DH,0AH,0DH,0AH
	DB	'VERSION TELEVIDEO MAY 9, 1982',0DH,0AH
	DB	'USING PRINTER PORT',0DH,0AH,'$'
;
SIGNON:	PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,MESSGE
	MVI	C,9
	CALL	5		;ANOUNCE VERSION TO USER
	POP	H
	POP	D
	POP	B
	RET
;
	END	BEGIN
